#property copyright "Copyright  2008, FOREXflash Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color1 White
#property indicator_color2 Lime
#property indicator_color3 Red
#property indicator_color4 Black
#property indicator_color5 Gray
#property indicator_color6 Gray
#property indicator_color7 Red
#property indicator_color8 Lime

extern bool ShowText = TRUE;
extern int Corner = 1;
extern int MA_Length = 100;
extern color Trending = C'0x23,0x23,0x23';
extern color Ranging = Black;
double g_ibuf_96[];
double g_ibuf_100[];
double g_ibuf_104[];
double g_ibuf_108[];
double g_ibuf_112[];
double g_ibuf_116[];
double g_ibuf_120[];
double g_ibuf_124[];
int gi_128 = 1;
string gs_132;

int init() {
   
   SetIndexBuffer(0, g_ibuf_96);
   SetIndexStyle(0, DRAW_HISTOGRAM);
   SetIndexLabel(0, "Spread(High-Low)");
   SetIndexStyle(1, DRAW_HISTOGRAM);
   SetIndexBuffer(1, g_ibuf_100);
   SetIndexLabel(1, "UpperWick");
   SetIndexStyle(2, DRAW_HISTOGRAM);
   SetIndexBuffer(2, g_ibuf_104);
   SetIndexLabel(2, "LowerWick");
   SetIndexBuffer(3, g_ibuf_108);
   SetIndexStyle(3, DRAW_NONE);
   SetIndexBuffer(4, g_ibuf_112);
   SetIndexStyle(4, DRAW_LINE, STYLE_DOT);
   SetIndexLabel(4, "AverageSpread");
   SetIndexBuffer(5, g_ibuf_116);
   SetIndexStyle(5, DRAW_ARROW, STYLE_SOLID);
   SetIndexArrow(5, 117);
   SetIndexLabel(5, "DivergenceNone");
   SetIndexBuffer(6, g_ibuf_120);
   SetIndexStyle(6, DRAW_ARROW, STYLE_SOLID);
   SetIndexArrow(6, 117);
   SetIndexLabel(6, "DivergenceTrending");
   SetIndexBuffer(7, g_ibuf_124);
   SetIndexStyle(7, DRAW_ARROW, STYLE_SOLID);
   SetIndexArrow(7, 117);
   SetIndexLabel(7, "DivergenceBearish");
   string ls_12 = "VSA WICK/SPREAD/DIVERGENCE";
   IndicatorShortName(ls_12);
   gs_132 = ls_12;
   ObjectDelete("Spread(High-Low)");
   IndicatorDigits(1);
   return (1);
}

int deinit() {
   string l_name_4;
   for (int li_0 = ObjectsTotal() - 1; li_0 >= 0; li_0--) {
      l_name_4 = ObjectName(li_0);
      if (StringSubstr(l_name_4, 0, 8) == "RSXTrend") ObjectDelete(l_name_4);
   }
   ObjectsDeleteAll(0, OBJ_LABEL);
   return (0);
}

int start() {
   double ld_28;
   double ld_36;
   double ld_44;
  
   if (ShowText == TRUE) draw_objects();
   AVGVolume();
   Div();
   int li_20 = IndicatorCounted();
   if (li_20 < 0) return (-1);
   if (li_20 > 0) li_20--;
   for (int li_24 = Bars - li_20; li_24 >= 0; li_24--) {
      ld_28 = iHigh(NULL, 0, li_24) - iLow(NULL, 0, li_24);
      g_ibuf_96[li_24] = ld_28 / Point / gi_128;
      if (iOpen(NULL, 0, li_24) > iClose(NULL, 0, li_24)) ld_36 = iHigh(NULL, 0, li_24) - iOpen(NULL, 0, li_24);
      if (iOpen(NULL, 0, li_24) <= iClose(NULL, 0, li_24)) ld_36 = iHigh(NULL, 0, li_24) - iClose(NULL, 0, li_24);
      if (iOpen(NULL, 0, li_24) > iClose(NULL, 0, li_24)) ld_44 = iLow(NULL, 0, li_24) - iClose(NULL, 0, li_24);
      if (iOpen(NULL, 0, li_24) <= iClose(NULL, 0, li_24)) ld_44 = iLow(NULL, 0, li_24) - iOpen(NULL, 0, li_24);
      g_ibuf_100[li_24] = ld_36 / Point / gi_128;
      g_ibuf_104[li_24] = ld_44 / Point / gi_128;
   }
   return (0);
}

int AVGVolume() {
   string l_name_16;
   int l_window_0 = WindowFind("VSA WICK/SPREAD/DIVERGENCE");
   int li_12 = IndicatorCounted();
   if (li_12 > 0) li_12--;
   int li_8 = Bars - li_12;
   for (int li_4 = 0; li_4 < li_8; li_4++) g_ibuf_108[li_4] = (iHigh(NULL, 0, li_4) - iLow(NULL, 0, li_4)) / Point / gi_128;
   for (li_4 = 0; li_4 < li_8; li_4++) g_ibuf_112[li_4] = iMAOnArray(g_ibuf_108, 0, MA_Length, 0, MODE_EMA, li_4);
   int l_count_24 = 0;
   for (li_4 = li_8 - 1; li_4 > 0; li_4--) {
      if (g_ibuf_108[li_4] > g_ibuf_112[li_4]) {
         l_count_24++;
         l_name_16 = "RSXTrend" + l_count_24;
         if (ObjectFind(l_name_16) == -1) ObjectCreate(l_name_16, OBJ_RECTANGLE, l_window_0, 0, 0);
         ObjectSet(l_name_16, OBJPROP_COLOR, Ranging);
         ObjectSet(l_name_16, OBJPROP_PRICE1, 100000);
         ObjectSet(l_name_16, OBJPROP_PRICE2, -100000);
         ObjectSet(l_name_16, OBJPROP_TIME1, Time[li_4]);
         ObjectSet(l_name_16, OBJPROP_TIME2, Time[li_4 - 1]);
      } else {
         if (g_ibuf_108[li_4] < g_ibuf_112[li_4]) {
            l_count_24++;
            l_name_16 = "RSXTrend" + l_count_24;
            if (ObjectFind(l_name_16) == -1) ObjectCreate(l_name_16, OBJ_RECTANGLE, l_window_0, 0, 0);
            ObjectSet(l_name_16, OBJPROP_COLOR, Trending);
            ObjectSet(l_name_16, OBJPROP_PRICE1, 100000);
            ObjectSet(l_name_16, OBJPROP_PRICE2, -100000);
            ObjectSet(l_name_16, OBJPROP_TIME1, Time[li_4]);
            ObjectSet(l_name_16, OBJPROP_TIME2, Time[li_4 - 1]);
         } else ObjectSet(l_name_16, OBJPROP_TIME2, Time[li_4 - 1]);
      }
   }
   return (0);
}

void Div() {
   for (int l_index_0 = 0; l_index_0 < 500; l_index_0++) {
      g_ibuf_116[l_index_0] = g_ibuf_96[l_index_0];
      if (Close[l_index_0] > Open[l_index_0 + 1] && Volume[l_index_0] < Volume[l_index_0 + 1]) g_ibuf_120[l_index_0] = g_ibuf_96[l_index_0];
      if (Close[l_index_0] < Open[l_index_0 + 1] && Volume[l_index_0] < Volume[l_index_0 + 1]) g_ibuf_124[l_index_0] = g_ibuf_96[l_index_0];
   }
}

void draw_objects() {
   ObjectCreate("Box", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("Box", "V  S  A  ", 14, "Trebuchet MS", Orange);
   ObjectSet("Box", OBJPROP_CORNER, Corner);
   ObjectSet("Box", OBJPROP_XDISTANCE, 15);
   ObjectSet("Box", OBJPROP_YDISTANCE, 1);
   ObjectCreate("Box1", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("Box1", "Spread/Wick/Candle", 8, "Trebuchet MS", Gray);
   ObjectSet("Box1", OBJPROP_CORNER, Corner);
   ObjectSet("Box1", OBJPROP_XDISTANCE, 15);
   ObjectSet("Box1", OBJPROP_YDISTANCE, 18);
   string l_dbl2str_0 = DoubleToStr(g_ibuf_96[0], 1);
   ObjectCreate("Spread(High-Low)", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("Spread(High-Low)", "Spread(H-L):" + l_dbl2str_0, 13, "Trebuchet MS", White);
   ObjectSet("Spread(High-Low)", OBJPROP_CORNER, Corner);
   ObjectSet("Spread(High-Low)", OBJPROP_XDISTANCE, 15);
   ObjectSet("Spread(High-Low)", OBJPROP_YDISTANCE, 34);
   ObjectCreate("BA_Spread(High-Low)", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("BA_Spread(High-Low)", "SPREAD IS BELOW AVERAGE.", 8, "Trebuchet MS", White);
   ObjectSet("BA_Spread(High-Low)", OBJPROP_CORNER, Corner);
   ObjectSet("BA_Spread(High-Low)", OBJPROP_XDISTANCE, 15);
   ObjectSet("BA_Spread(High-Low)", OBJPROP_YDISTANCE, 54);
   if (g_ibuf_96[0] > g_ibuf_112[0]) ObjectSetText("BA_Spread(High-Low)", "SPREAD IS ABOVE AVERAGE!!!", 8, "Trebuchet MS", Red);
   string l_dbl2str_8 = DoubleToStr(g_ibuf_100[0], 1);
   ObjectCreate("UpWick", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("UpWick", "WICK: " + l_dbl2str_8, 9, "Trebuchet MS", Lime);
   ObjectSet("UpWick", OBJPROP_CORNER, Corner);
   ObjectSet("UpWick", OBJPROP_XDISTANCE, 85);
   ObjectSet("UpWick", OBJPROP_YDISTANCE, 70);
   string l_dbl2str_16 = DoubleToStr(g_ibuf_104[0], 1);
   ObjectCreate("DnWick", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("DnWick", "WICK:" + l_dbl2str_16, 9, "Trebuchet MS", Red);
   ObjectSet("DnWick", OBJPROP_CORNER, Corner);
   ObjectSet("DnWick", OBJPROP_XDISTANCE, 15);
   ObjectSet("DnWick", OBJPROP_YDISTANCE, 70);
   ObjectCreate("Div", OBJ_LABEL, WindowFind(gs_132), 0, 0);
   ObjectSetText("Div", "Divergance:None", 13, "Trebuchet MS", White);
   ObjectSet("Div", OBJPROP_CORNER, Corner);
   ObjectSet("Div", OBJPROP_XDISTANCE, 15);
   ObjectSet("Div", OBJPROP_YDISTANCE, 85);
   if (Close[1] > Open[2] && Volume[1] < Volume[2]) ObjectSetText("Div", "Divergance:Bearish", 13, "Trebuchet MS", Red);
   if (Close[1] < Open[2] && Volume[1] < Volume[2]) ObjectSetText("Div", "Divergance:Bullish", 13, "Trebuchet MS", Lime);
}